/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.lightweightbml.xmltags;

import java.util.LinkedList;
import org.jvoicexml.implementation.lightweightbml.xmltags.BlockProgress;
import org.jvoicexml.implementation.lightweightbml.xmltags.Constraint;
import org.jvoicexml.implementation.lightweightbml.xmltags.ITag;
import org.jvoicexml.implementation.lightweightbml.xmltags.SyncPoint;
import org.jvoicexml.implementation.lightweightbml.xmltags.Warning;

public class BML {
    private String character;
    private String id;
    private LinkedList<ITag> commands;
    private LinkedList<Constraint> constraints;
    private LinkedList<Warning> warnings;
    private LinkedList<BlockProgress> blockProgresses;
    private LinkedList<SyncPoint> syncPoints;

    public BML(String theCharacter, String theID) {
        this.character = theCharacter;
        this.id = theID;
        this.commands = new LinkedList();
        this.constraints = new LinkedList();
        this.warnings = new LinkedList();
        this.blockProgresses = new LinkedList();
        this.syncPoints = new LinkedList();
    }

    public final void setCharacter(String newCharacter) {
        this.character = newCharacter;
    }

    public final void setID(String newID) {
        this.id = newID;
    }

    public final String getCharacter() {
        return this.character;
    }

    public final String getID() {
        return this.id;
    }

    public final LinkedList<ITag> getCommands() {
        return this.commands;
    }

    public final LinkedList<Constraint> getConstraints() {
        return this.constraints;
    }

    public final LinkedList<BlockProgress> getBlockProgresses() {
        return this.blockProgresses;
    }

    public final LinkedList<SyncPoint> getSyncPoints() {
        return this.syncPoints;
    }

    public final LinkedList<Warning> getWarnings() {
        return this.warnings;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<bml>");
        builder.append("<required>");
        for (ITag tag : this.commands) {
            if (!tag.isRequired()) continue;
            builder.append(tag.toString());
        }
        for (Constraint c : this.constraints) {
            if (!c.isRequired()) continue;
            builder.append(c.toString());
        }
        builder.append("</required>");
        for (ITag tag : this.commands) {
            if (tag.isRequired()) continue;
            builder.append(tag.toString());
        }
        for (Constraint c : this.constraints) {
            if (c.isRequired()) continue;
            builder.append(c.toString());
        }
        for (Warning w : this.warnings) {
            builder.append(w.toString());
        }
        for (BlockProgress b : this.blockProgresses) {
            builder.append(b.toString());
        }
        for (SyncPoint p : this.syncPoints) {
            builder.append(p.toString());
        }
        builder.append("</bml>");
        return builder.toString();
    }
}

