/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.lightweightbml.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jvoicexml.implementation.lightweightbml.xmltags.After;
import org.jvoicexml.implementation.lightweightbml.xmltags.BML;
import org.jvoicexml.implementation.lightweightbml.xmltags.BlockProgress;
import org.jvoicexml.implementation.lightweightbml.xmltags.Constraint;
import org.jvoicexml.implementation.lightweightbml.xmltags.Gaze;
import org.jvoicexml.implementation.lightweightbml.xmltags.Gesture;
import org.jvoicexml.implementation.lightweightbml.xmltags.Pointing;
import org.jvoicexml.implementation.lightweightbml.xmltags.Speech;
import org.jvoicexml.implementation.lightweightbml.xmltags.Sync;
import org.jvoicexml.implementation.lightweightbml.xmltags.SyncPoint;
import org.jvoicexml.implementation.lightweightbml.xmltags.Synchronize;
import org.jvoicexml.implementation.lightweightbml.xmltags.Wait;
import org.jvoicexml.implementation.lightweightbml.xmltags.Warning;
import org.xml.sax.SAXException;

public class LightweightBMLParser {
    private SAXBuilder xmlBuilder = new SAXBuilder();
    private BML bmlTree;

    public LightweightBMLParser(String xsdFileName) throws SAXException {
    }

    public final BML generateBML(String bmlString) throws JDOMException, IOException {
        Document doc = this.xmlBuilder.build((Reader)new StringReader(bmlString.trim()));
        Element root = doc.getRootElement();
        return this.generateBML(root);
    }

    protected final BML generateBML(Element xmlRootElement) {
        String character = xmlRootElement.getAttributeValue("character", "");
        String bmlID = xmlRootElement.getAttributeValue("id", "");
        this.bmlTree = new BML(character, bmlID);
        for (Element element : xmlRootElement.getChildren()) {
            String elementName = element.getName();
            if (elementName.compareTo("required") == 0) {
                this.generateRequired(element);
                continue;
            }
            if (elementName.compareTo("constraint") == 0) {
                this.generateConstraint(element, false);
                continue;
            }
            if (elementName.compareTo("warningFeedback") == 0) {
                this.generateWarning(element);
                continue;
            }
            if (elementName.compareTo("syncPointProgress") == 0) {
                this.generateSyncPoint(element);
                continue;
            }
            if (elementName.compareTo("blockProgress") == 0) {
                this.generateBlockProgress(element);
                continue;
            }
            this.generateCommand(element, false);
        }
        return this.bmlTree;
    }

    protected final void generateRequired(Element requiredElement) {
        for (Element requiredSubelement : requiredElement.getChildren()) {
            String requiredElementName = requiredSubelement.getName();
            if (requiredElementName.compareTo("constraint") == 0) {
                this.generateConstraint(requiredSubelement, true);
                continue;
            }
            this.generateCommand(requiredSubelement, true);
        }
    }

    protected final void generateConstraint(Element xmlConstraintElement, boolean required) {
        Constraint c = new Constraint(required);
        for (Element s : xmlConstraintElement.getChildren("synchronize")) {
            Synchronize synchronize = new Synchronize();
            for (Element sync : s.getChildren("sync")) {
                String ref = sync.getAttributeValue("ref", "");
                if (ref.compareTo("") == 0) continue;
                synchronize.getSyncPoints().add(new Sync(ref));
            }
            c.getSynchronizes().add(synchronize);
        }
        for (Element a : xmlConstraintElement.getChildren("after")) {
            String ref = a.getAttributeValue("ref", "");
            After after = new After(ref);
            for (Element sync : a.getChildren("sync")) {
                String sref = sync.getAttributeValue("ref", "");
                if (ref.compareTo("") == 0) continue;
                after.getSyncPoints().add(new Sync(sref));
            }
            c.getAfters().add(after);
        }
        this.bmlTree.getConstraints().add(c);
    }

    protected final void generateWarning(Element xmlWarningElement) {
        String id = xmlWarningElement.getAttributeValue("id", "");
        String character = xmlWarningElement.getAttributeValue("characterId", "");
        String type = xmlWarningElement.getAttributeValue("type", "");
        this.bmlTree.getWarnings().add(new Warning(id, character, type));
    }

    protected final void generateSyncPoint(Element xmlSyncPointElement) {
        String id = xmlSyncPointElement.getAttributeValue("id", "");
        String time = xmlSyncPointElement.getAttributeValue("time", "");
        String globalTime = xmlSyncPointElement.getAttributeValue("globalTime", "");
        String character = xmlSyncPointElement.getAttributeValue("characterId", "");
        this.bmlTree.getSyncPoints().add(new SyncPoint(id, time, globalTime, character));
    }

    protected final void generateBlockProgress(Element xmlBlockProgressElement) {
        String id = xmlBlockProgressElement.getAttributeValue("id", "");
        String globalTime = xmlBlockProgressElement.getAttributeValue("globalTime", "");
        String character = xmlBlockProgressElement.getAttributeValue("characterId", "");
        BlockProgress bp = new BlockProgress(id, globalTime, character);
        this.bmlTree.getBlockProgresses().add(bp);
    }

    protected final void generateCommand(Element xmlCommandElement, boolean required) {
        String name = xmlCommandElement.getName();
        String id = xmlCommandElement.getAttributeValue("id", "");
        String start = xmlCommandElement.getAttributeValue("start", "-not set-");
        String end = xmlCommandElement.getAttributeValue("end", "-not set-");
        if (name.compareTo("wait") == 0) {
            String duration = xmlCommandElement.getAttributeValue("duration", "-not set-");
            this.bmlTree.getCommands().add(new Wait(id, required, start, end, duration));
        } else if (name.compareTo("gesture") == 0) {
            String lexeme = xmlCommandElement.getAttributeValue("lexeme", "-unknown-");
            this.bmlTree.getCommands().add(new Gesture(id, required, start, end, lexeme));
        } else if (name.compareTo("speech") == 0) {
            String text = xmlCommandElement.getChild("text").getTextTrim();
            this.bmlTree.getCommands().add(new Speech(id, required, start, end, text));
        } else if (name.compareTo("pointing") == 0) {
            String mode = xmlCommandElement.getAttributeValue("mode", "");
            String target = xmlCommandElement.getAttributeValue("target", "");
            Pointing p = new Pointing(id, required, start, end, mode, target);
            this.bmlTree.getCommands().add(p);
        } else if (name.compareTo("gaze") == 0) {
            String mode = xmlCommandElement.getAttributeValue("mode", "");
            String target = xmlCommandElement.getAttributeValue("target", "");
            Gaze g = new Gaze(id, required, start, end, mode, target);
            this.bmlTree.getCommands().add(g);
        }
    }
}

