/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.lightweightbml.connection;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Observable;
import org.jvoicexml.implementation.lightweightbml.xmltags.BML;

public final class UDPConnection
extends Observable
implements Runnable {
    private DatagramSocket socket = null;
    private Thread thread = null;
    private int bufferSize;
    private byte[] buffer = null;

    public UDPConnection(int theBufferSize) {
        this.bufferSize = theBufferSize;
    }

    public void connect(String host, int port) throws UnknownHostException, SocketException {
        if (this.socket != null) {
            this.disconnect();
        }
        this.socket = new DatagramSocket();
        this.socket.connect(Inet4Address.getByName(host), port);
    }

    public void bind(String host, int port) throws SocketException {
        if (this.socket != null) {
            this.disconnect();
        }
        this.socket = new DatagramSocket(new InetSocketAddress(host, port));
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void disconnect() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.socket.close();
        this.socket = null;
    }

    public void send(String bmlString) {
        try {
            byte[] stringBytes = bmlString.getBytes("UTF-8");
            DatagramPacket packet = new DatagramPacket(stringBytes, stringBytes.length);
            this.socket.send(packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void send(BML bml) {
        this.send(bml.toString());
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.buffer = new byte[this.bufferSize];
                    DatagramPacket packet = new DatagramPacket(this.buffer, this.bufferSize);
                    if (this.socket == null) {
                        return;
                    }
                    this.socket.receive(packet);
                    String str = new String(packet.getData(), "UTF-8");
                    this.setChanged();
                    this.notifyObservers(str);
                }
            }
            catch (IOException e) {
                if (e.getMessage().compareTo("socket closed") == 0) {
                    return;
                }
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

