/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.lightweightbml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;
import org.jvoicexml.ConnectionInformation;
import org.jvoicexml.DocumentServer;
import org.jvoicexml.SpeakableSsmlText;
import org.jvoicexml.SpeakableText;
import org.jvoicexml.event.ErrorEvent;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.event.plain.implementation.OutputEndedEvent;
import org.jvoicexml.event.plain.implementation.QueueEmptyEvent;
import org.jvoicexml.event.plain.implementation.SynthesizedOutputEvent;
import org.jvoicexml.implementation.SynthesizedOutput;
import org.jvoicexml.implementation.SynthesizedOutputListener;
import org.jvoicexml.implementation.lightweightbml.BMLClient;
import org.jvoicexml.implementation.lightweightbml.BMLFeedback;
import org.jvoicexml.implementation.lightweightbml.ExternalBMLPublisher;
import org.jvoicexml.implementation.lightweightbml.QueuedSpeakable;
import org.jvoicexml.implementation.lightweightbml.SpeakableQueue;
import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.ssml.Speak;
import org.jvoicexml.xml.ssml.SsmlDocument;
import org.jvoicexml.xml.vxml.BargeInType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class BMLSynthesizedOutput
implements SynthesizedOutput,
BMLClient {
    private static final Logger LOGGER = Logger.getLogger(BMLSynthesizedOutput.class);
    private static final String BML_NAMESPACE_URI = "http://www.mindmakers.org/projects/bml-1-0/wiki";
    private static final String ENCODING = "UTF-8";
    private String type;
    private DatagramSocket socket;
    private InetAddress host;
    private int port;
    private int feedbackPort;
    private BMLFeedback feedback;
    private final Collection<SynthesizedOutputListener> listeners = new ArrayList<SynthesizedOutputListener>();
    private final SpeakableQueue speakables = new SpeakableQueue();
    private String sessionId;
    private ExternalBMLPublisher external;

    public void setExternalBMLPublisher(ExternalBMLPublisher publisher) {
        this.external = publisher;
        if (this.external != null) {
            this.external.setBMLClient(this);
        }
    }

    public ExternalBMLPublisher getExternalBMLPublisher() {
        return this.external;
    }

    public void setHost(String value) throws UnknownHostException {
        this.host = value == null ? null : InetAddress.getByName(value);
    }

    public void setPort(int portNumber) {
        this.port = portNumber;
    }

    public void setFeedbackPort(int portNumber) {
        this.feedbackPort = portNumber;
    }

    public String getType() {
        return this.type;
    }

    void setType(String typeName) {
        this.type = typeName;
    }

    public void open() throws NoresourceError {
        try {
            this.connect();
        }
        catch (IOException e) {
            throw new NoresourceError(e.getMessage(), (Throwable)e);
        }
        if (this.external != null) {
            try {
                LOGGER.info((Object)"starting external BML publisher");
                this.external.start();
            }
            catch (IOException e) {
                throw new NoresourceError(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void activate() throws NoresourceError {
        LOGGER.info((Object)"BML synthesized output activated");
    }

    public void passivate() throws NoresourceError {
        this.speakables.clear();
        LOGGER.info((Object)"BML synthesized output passivated");
    }

    public void close() {
        if (this.external != null) {
            try {
                LOGGER.info((Object)"stopping external BML publisher");
                this.external.stop();
            }
            catch (IOException e) {
                LOGGER.warn((Object)"error closing the external listener", (Throwable)e);
            }
        }
        try {
            this.disconnect();
        }
        catch (IOException e) {
            LOGGER.warn((Object)"error disconnecting from Avatar", (Throwable)e);
        }
    }

    public boolean isBusy() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("busy status: " + this.speakables.size() + " messages to send"));
        }
        return !this.speakables.isEmpty();
    }

    private void connect() throws IOException {
        if (this.socket != null) {
            return;
        }
        if (this.host == null) {
            this.host = InetAddress.getLocalHost();
        }
        this.socket = new DatagramSocket();
        this.socket.connect(this.host, this.port);
        LOGGER.info((Object)("connected to Avatar at '" + this.host + ":" + this.port));
        this.feedback = new BMLFeedback(this, this.feedbackPort);
        this.feedback.start();
    }

    private void disconnect() throws IOException {
        if (this.socket == null) {
            return;
        }
        try {
            this.feedback.interrupt();
            this.feedback = null;
            this.socket.disconnect();
            this.socket.close();
        }
        finally {
            this.socket = null;
            this.feedback = null;
        }
        LOGGER.info((Object)"diconnected from Avatar");
    }

    public void connect(ConnectionInformation client) throws IOException {
        if (this.external == null) {
            this.connect();
        }
    }

    public void disconnect(ConnectionInformation client) {
        if (this.external == null) {
            try {
                this.disconnect();
            }
            catch (IOException ex) {
                LOGGER.warn((Object)"error diconnecting from Avatar", (Throwable)ex);
            }
        }
    }

    public boolean supportsBargeIn() {
        return false;
    }

    public void cancelOutput(BargeInType bargeInType) throws NoresourceError {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SynthesizedOutputListener listener) {
        Collection<SynthesizedOutputListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SynthesizedOutputListener listener) {
        Collection<SynthesizedOutputListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSpeakable(SpeakableText speakable, String id, DocumentServer documentServer) throws NoresourceError, BadFetchError {
        SpeakableQueue speakableQueue = this.speakables;
        synchronized (speakableQueue) {
            this.sessionId = id;
            this.speakables.offer(speakable);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("queued speakable '" + speakable + "'"));
            }
            if (this.speakables.size() == 1) {
                this.sendNextSpeakable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNextSpeakable() {
        String utterance;
        SsmlDocument document;
        QueuedSpeakable next = this.speakables.peek();
        SpeakableText speakable = next.getSpeakable();
        if (speakable instanceof SpeakableSsmlText) {
            SpeakableSsmlText ssml = (SpeakableSsmlText)speakable;
            document = ssml.getDocument();
            Speak speak = document.getSpeak();
            utterance = speak.getTextContent();
        } else {
            utterance = speakable.getSpeakableText();
            document = null;
        }
        BadFetchError error = null;
        try {
            String bml = this.createBML(utterance, document);
            this.sendToAvatar(bml);
        }
        catch (SocketException e) {
            error = new BadFetchError(e.getMessage(), (Throwable)e);
        }
        catch (UnknownHostException e) {
            error = new BadFetchError(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            error = new BadFetchError(e.getMessage(), (Throwable)e);
        }
        catch (XMLStreamException e) {
            error = new BadFetchError(e.getMessage(), (Throwable)e);
        }
        if (error != null) {
            Collection<SynthesizedOutputListener> collection = this.listeners;
            synchronized (collection) {
                for (SynthesizedOutputListener listener : this.listeners) {
                    listener.outputError((ErrorEvent)error);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendToAvatar(String bml) throws IOException {
        DatagramSocket datagramSocket = this.socket;
        synchronized (datagramSocket) {
            byte[] buffer = bml.getBytes(ENCODING);
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length, this.host, this.port);
            this.socket.send(packet);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("sent utterance '" + bml + "' to '" + this.host + ":" + this.port));
            }
        }
    }

    private String createBML(String utterance, SsmlDocument ssml) throws XMLStreamException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(out, ENCODING);
        writer.writeStartDocument(ENCODING, "1.0");
        writer.writeStartElement("bml");
        writer.writeAttribute("id", "bml1");
        writer.writeNamespace("ns1", BML_NAMESPACE_URI);
        if (ssml != null) {
            Speak speak = ssml.getSpeak();
            NodeList children = speak.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                String namespace = child.getNamespaceURI();
                if (namespace == null) continue;
                this.writeBMLNode(writer, child, utterance);
            }
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
        try {
            String output = out.toString(ENCODING);
            return output;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            return out.toString();
        }
    }

    private void writeBMLNode(XMLStreamWriter writer, Node node, String utterance) throws XMLStreamException {
        if (node instanceof Text) {
            Text text = (Text)node;
            String content = text.getTextContent();
            writer.writeCharacters(content);
            return;
        }
        String tag = node.getNodeName();
        writer.writeStartElement(tag);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int k = 0; k < attributes.getLength(); ++k) {
                Node attribute = attributes.item(k);
                String name = attribute.getNodeName();
                String value = attribute.getNodeValue();
                writer.writeAttribute(name, value);
            }
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            this.writeBMLNode(writer, child, utterance);
        }
        if (tag.contains("speech")) {
            writer.writeStartElement("text");
            writer.writeCharacters(utterance);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void playEnded(String id) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("speech with id '" + id + "' ended"));
        }
        SpeakableQueue speakableQueue = this.speakables;
        synchronized (speakableQueue) {
            QueuedSpeakable queuedSpeakable = this.speakables.poll();
            if (queuedSpeakable == null) {
                return;
            }
            SpeakableText speakable = queuedSpeakable.getSpeakable();
            OutputEndedEvent event = new OutputEndedEvent((SynthesizedOutput)this, this.sessionId, speakable);
            Collection<SynthesizedOutputListener> collection = this.listeners;
            synchronized (collection) {
                for (SynthesizedOutputListener listener : this.listeners) {
                    listener.outputStatusChanged((SynthesizedOutputEvent)event);
                }
            }
            if (this.speakables.isEmpty()) {
                LOGGER.info((Object)"BML queue is empty");
                QueueEmptyEvent emptyEvent = new QueueEmptyEvent((SynthesizedOutput)this, this.sessionId);
                Collection<SynthesizedOutputListener> collection2 = this.listeners;
                synchronized (collection2) {
                    for (SynthesizedOutputListener listener : this.listeners) {
                        listener.outputStatusChanged((SynthesizedOutputEvent)emptyEvent);
                    }
                }
            } else {
                this.sendNextSpeakable();
            }
        }
    }

    public void waitNonBargeInPlayed() {
    }

    public void waitQueueEmpty() {
        try {
            this.speakables.waitQueueEmpty();
        }
        catch (InterruptedException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
            e.printStackTrace();
        }
    }
}

