/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.lightweightbml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.jvoicexml.implementation.lightweightbml.BMLSynthesizedOutput;
import org.jvoicexml.implementation.lightweightbml.ResponseExtractor;

class BMLFeedback
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(BMLFeedback.class);
    private static final int BUFFER_SIZE = 1024;
    private final int port;
    private final BMLSynthesizedOutput output;

    public BMLFeedback(BMLSynthesizedOutput bmlOutput, int portNumber) {
        this.setDaemon(true);
        this.output = bmlOutput;
        this.port = portNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        socket = null;
        try {
            try {
                socket = new DatagramSocket(this.port);
                BMLFeedback.LOGGER.info((Object)("receiving feedback from Avatar at port " + this.port));
                buffer = new byte[1024];
                out = new ByteArrayOutputStream();
                while (true) lbl-1000:
                // 5 sources

                {
                    packet = new DatagramPacket(buffer, buffer.length);
                    socket.receive(packet);
                    out.write(buffer, 0, packet.getLength());
                    response = out.toString();
                    BMLFeedback.LOGGER.info((Object)("received from Avatar: '" + response + "'"));
                    try {
                        id = this.parseId(response);
                        if (!this.isEndOfSpeech(id)) ** GOTO lbl-1000
                        this.output.playEnded(id);
                    }
                    catch (TransformerException e) {
                        BMLFeedback.LOGGER.warn((Object)"error parsing the response from Avatar", (Throwable)e);
                    }
                    finally {
                        out.reset();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                BMLFeedback.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                if (socket != null) {
                    socket.close();
                }
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var8_10) {
            if (socket != null) {
                socket.close();
            }
            throw var8_10;
        }
    }

    private String parseId(String response) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StringReader reader = new StringReader(response);
        StreamSource source = new StreamSource(reader);
        ResponseExtractor extractor = new ResponseExtractor();
        SAXResult result = new SAXResult(extractor);
        transformer.transform(source, result);
        return extractor.getEventId();
    }

    private boolean isEndOfSpeech(String id) {
        return id.equals("bml1:end");
    }
}

