/*
 * Decompiled with CFR 0.152.
 */
package org.dontpanic.spanners.springmvc.services;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.dontpanic.spanners.springmvc.domain.User;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.hateoas.hal.Jackson2HalModule;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class RestUserDetailsService
implements UserDetailsManager {
    private RestTemplate restTemplate;

    public RestUserDetailsService(RestTemplateBuilder builder, @Value(value="${app.service.url.users}") String rootUri) {
        this.restTemplate = builder.messageConverters(new HttpMessageConverter[]{this.halAwareMessageConverter()}).rootUri(rootUri).build();
    }

    private HttpMessageConverter halAwareMessageConverter() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new Jackson2HalModule());
        return new MappingJackson2HttpMessageConverter(mapper);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return (UserDetails)this.restTemplate.getForObject("/{0}", User.class, new Object[]{username});
    }

    public void createUser(UserDetails userDetails) {
        this.restTemplate.postForLocation("/", (Object)userDetails, new Object[0]);
    }

    public void updateUser(UserDetails userDetails) {
        this.restTemplate.put("/{0}", (Object)userDetails, new Object[]{userDetails.getUsername()});
    }

    public void deleteUser(String username) {
        this.restTemplate.delete("/{0}", new Object[]{username});
    }

    public void changePassword(String username, String password) {
        User user = new User();
        user.setUsername(username);
        user.setPassword(password);
        HttpEntity requestEntity = new HttpEntity((Object)user);
        this.restTemplate.exchange("/{0}", HttpMethod.PATCH, requestEntity, Void.class, new Object[]{username});
    }

    public boolean userExists(String username) {
        try {
            ResponseEntity responseEntity = this.restTemplate.getForEntity("/{0}", User.class, new Object[]{username});
            return HttpStatus.OK.equals((Object)responseEntity.getStatusCode());
        }
        catch (HttpClientErrorException e) {
            return false;
        }
    }
}

