/*
 * Decompiled with CFR 0.152.
 */
package org.dontpanic.spanners.springmvc.controllers;

import javax.validation.Valid;
import org.dontpanic.spanners.springmvc.domain.User;
import org.dontpanic.spanners.springmvc.forms.SignupForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class SignupController {
    public static final String CONTROLLER_URL = "/signup";
    public static final String VIEW_SUCCESS = "redirect:/";
    private static final boolean ENABLED = true;
    @Autowired
    private UserDetailsManager userDetailsManager;
    @Autowired
    private PasswordEncoder passwordEncoder;

    @RequestMapping(value={"/signup"})
    public SignupForm displayPage() {
        return new SignupForm();
    }

    @RequestMapping(value={"/signup"}, method={RequestMethod.POST})
    public String signup(@Valid @ModelAttribute SignupForm signupForm, Errors errors) {
        if (errors.hasErrors()) {
            return null;
        }
        String hashedPassword = this.passwordEncoder.encode((CharSequence)signupForm.getPassword());
        User userDetails = new User(signupForm.getName(), hashedPassword, Boolean.valueOf(true));
        this.userDetailsManager.createUser((UserDetails)userDetails);
        return VIEW_SUCCESS;
    }
}

