/*
 * Decompiled with CFR 0.152.
 */
package org.dontpanic.spanners.springmvc.services;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import org.dontpanic.spanners.springmvc.domain.Spanner;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.hal.Jackson2HalModule;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SpannersService {
    private RestTemplate restTemplate;

    public SpannersService(RestTemplateBuilder builder, @Value(value="${app.service.url.spanners}") String rootUri) {
        this.restTemplate = builder.messageConverters(new HttpMessageConverter[]{this.halAwareMessageConverter()}).rootUri(rootUri).build();
    }

    private HttpMessageConverter halAwareMessageConverter() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new Jackson2HalModule());
        return new MappingJackson2HttpMessageConverter(mapper);
    }

    public Collection<Spanner> findAll() {
        ResponseEntity response = this.restTemplate.exchange("/", HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        PagedResources pages = (PagedResources)response.getBody();
        return pages.getContent();
    }

    public Spanner findOne(Long id) {
        return (Spanner)this.restTemplate.getForObject("/{0}", Spanner.class, new Object[]{id});
    }

    public void delete(Spanner spanner) {
        this.restTemplate.delete("/{0}", new Object[]{spanner.getId()});
    }

    public void create(Spanner spanner) {
        this.restTemplate.postForObject("/", (Object)spanner, Spanner.class, new Object[0]);
    }

    public void update(Spanner spanner) {
        this.restTemplate.put("/{0}", (Object)spanner, new Object[]{spanner.getId()});
    }
}

