/*
 * Decompiled with CFR 0.152.
 */
package org.dontpanic.spanners.springmvc.services;

import java.util.Collection;
import org.dontpanic.spanners.springmvc.domain.Spanner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.PagedResources;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SpannersService {
    @Autowired
    private RestTemplate restTemplate;
    private String resourceUrl;
    private String itemUrl;

    @Autowired
    public SpannersService(@Value(value="${app.service.url.spanners}") String resourceUrl) {
        this.resourceUrl = resourceUrl.startsWith("http") ? resourceUrl : "http://" + resourceUrl;
        this.itemUrl = this.resourceUrl + "/{0}";
    }

    public Collection<Spanner> findAll() {
        ResponseEntity response = this.restTemplate.exchange(this.resourceUrl, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<PagedResources<Spanner>>(){}, new Object[0]);
        PagedResources pages = (PagedResources)response.getBody();
        return pages.getContent();
    }

    public Spanner findOne(Long id) {
        return (Spanner)this.restTemplate.getForObject(this.itemUrl, Spanner.class, new Object[]{id});
    }

    public void delete(Spanner spanner) {
        this.restTemplate.delete(this.itemUrl, new Object[]{spanner.getId()});
    }

    public void create(Spanner spanner) {
        this.restTemplate.postForObject(this.resourceUrl, (Object)spanner, Spanner.class, new Object[0]);
    }

    public void update(Spanner spanner) {
        this.restTemplate.put(this.itemUrl, (Object)spanner, new Object[]{spanner.getId()});
    }
}

