/*
 * Decompiled with CFR 0.152.
 */
package org.dontpanic.spanners.springmvc.controllers;

import javax.validation.Valid;
import org.dontpanic.spanners.springmvc.domain.Spanner;
import org.dontpanic.spanners.springmvc.exception.SpannerNotFoundException;
import org.dontpanic.spanners.springmvc.forms.SpannerForm;
import org.dontpanic.spanners.springmvc.services.SpannersService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EditSpannerController
implements ApplicationEventPublisherAware {
    public static final String VIEW_EDIT_SPANNER = "/editSpanner";
    public static final String VIEW_UPDATE_SUCCESS = "redirect:/displaySpanners";
    public static final String VIEW_VALIDATION_ERRORS = "/editSpanner";
    public static final String MODEL_SPANNER = "spanner";
    public static final String CONTROLLER_URL = "/editSpanner";
    @Autowired
    private SpannersService spannersService;
    private ApplicationEventPublisher eventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    @RequestMapping(value={"/editSpanner"}, method={RequestMethod.GET})
    public ModelAndView displayPage(@RequestParam Long id) throws SpannerNotFoundException {
        Spanner spanner = this.spannersService.findOne(id);
        if (spanner == null) {
            throw new SpannerNotFoundException(id);
        }
        SpannerForm initializedForm = new SpannerForm(spanner);
        return new ModelAndView("/editSpanner", MODEL_SPANNER, (Object)initializedForm);
    }

    @RequestMapping(value={"/editSpanner"}, method={RequestMethod.POST})
    public ModelAndView updateSpanner(@Valid @ModelAttribute(value="spanner") SpannerForm formData, BindingResult validationResult) {
        if (validationResult.hasErrors()) {
            return new ModelAndView("/editSpanner");
        }
        Spanner spanner = this.spannersService.findOne(formData.getId());
        spanner.setName(formData.getName());
        spanner.setSize(formData.getSize());
        this.spannersService.update(spanner);
        return new ModelAndView(VIEW_UPDATE_SUCCESS);
    }
}

