/*
 * Decompiled with CFR 0.152.
 */
package org.dontpanic.spanners.springmvc.controllers;

import java.util.Collection;
import org.dontpanic.spanners.springmvc.domain.Spanner;
import org.dontpanic.spanners.springmvc.exception.SpannerNotFoundException;
import org.dontpanic.spanners.springmvc.services.SpannersService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DisplaySpannersController {
    public static final String CONTROLLER_URL = "/displaySpanners";
    public static final String VIEW_DISPLAY_SPANNERS = "displaySpanners";
    public static final String MODEL_ATTRIBUTE_SPANNERS = "spanners";
    @Autowired
    private SpannersService spannersService;

    @RequestMapping(value={"/displaySpanners"}, method={RequestMethod.GET})
    public ModelAndView displaySpanners() {
        Collection<Spanner> spanners = this.spannersService.findAll();
        return new ModelAndView(VIEW_DISPLAY_SPANNERS, MODEL_ATTRIBUTE_SPANNERS, spanners);
    }

    @RequestMapping(value={"/deleteSpanner"}, method={RequestMethod.GET})
    public ModelAndView deleteSpanner(@RequestParam Long id) throws SpannerNotFoundException {
        Spanner spanner = this.spannersService.findOne(id);
        if (spanner == null) {
            throw new SpannerNotFoundException(id);
        }
        this.spannersService.delete(spanner);
        return this.displaySpanners();
    }
}

